'
' Egzemplarze tej klasy uzyskuj obiektyw klasy EmployeeProfile waciwe dla
' poszczeglnych pracownikw (identyfikowanych przez obiekty klasy EmployeeID).
'
Public Class EmployeeProfileManager
    Private cache As New EmployeeCache()
    Private server As New EmployeeProfileFetcher()

    '
    ' Zwraca profil pracownika wedug danego na wejciu identyfikatora; obiekt profilu
    ' moe pochodzi albo z wewntrznej pamici podrcznej, albo z serwera systemu
    ' rejestrujcego czasu (jeli pami podrczna nie zawiera odpowiedniego obiektu).
    '
    ' id  Identyfikator identyfikator pracownika.
    ' zwraca  Profil profil pracownika lub warto Nothing, jeli serwer systemu nie zawiera
    '          profilu zdefiniowanego dla danego na wejciu identyfikatora.
    '
    Function FetchEmployee(ByVal id As EmployeeID) As EmployeeProfile
        Dim emp As EmployeeProfile = cache.FetchEmployee(id)
        If emp Is Nothing Then          ' Jeli pami podrczna nie zawiera danego profilu, prbuje go uzyska bezporednio z serwera.
            emp = server.FetchEmployee(id)
            If emp IsNot Nothing Then   ' Udao si uzyska profil z serwera.
                cache.AddEmployee(emp)  ' Umieszcza profil w pamici podrcznej.
            End If
        End If
        Return emp
    End Function 'FetchEmployee

End Class 'EmployeeProfileManager
